<?php $title = 'Avocado Oil :: Greenava'; ?>
<?php include 'include/head.php'; ?>
<?php include 'include/header.php'; ?>
<style>
    .error {
        /* font-size: 17px !important; */
        color: red !important;
    }
</style>
    <!-- Banner Section -->
    <section class="banner-outer-section">
        <div class="banner-bg products-banner-bg"
            style="background-image: url(./assets/images/products/products-banner.jpg);">
            <div class="container">
                <div class="banner-inner-section">
                    <div class="banner-content" data-aos="fade-up" data-aos-offset="150">
                        <h2>Avocado Oil</h2>
                    </div>
                    <div class="banner-image" data-aos="zoom-in" data-aos-duration="1500">
                        <img src="./assets/images/products/products-banner-img.png" alt="">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Banner Section -->

    <section class="left-right-content-section products-left-right-content-section">
        <div class="container">
            <h2 class="section-title" data-aos="fade-up" data-aos-offset="150">Extra-Virgin and <span>Crude Avocado
                    Oil</span></h2>
            <div class="left-right-inner">
                <div class="left-content">
                    <!-- <h2>Purely Natural,<br />
                        <span>Passionately Greenava</span>
                    </h2> -->
                    <div class="content-para" data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">
                        <p>Premium Avocado Oil <br />for Health and Versatility</p>
                    </div>
                </div>
                <div class="right-content" data-aos="fade-up" data-aos-offset="150" data-aos-delay="100">
                    <p>Crafted using a cold-press method from handpicked, perfectly ripened avocados, our extra-virgin
                        avocado oil is 100% chemical- and additive-free. Rich in monounsaturated fats, vitamins E, A,
                        and D, and antioxidants, it’s ideal for culinary, cosmetic, and pharmaceutical applications. Its
                        high smoke point makes it perfect for cooking, while its nutrient profile enhances skincare and
                        haircare products.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Premium Crude Avocado Oil  -->
    <section class="premium-crude-avocado-oil">
        <div class="bg-wrapper" style="background-image: url(./assets/images/products/premium-bg.jpg);">
            <div class="container">
                <div class="green-life-inner">
                    <h4 data-aos="fade-up" data-aos-offset="150">Crude Avocado Oil</h4>
                    <h2 data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">Premium Avocado Oil for <br />
                        Health and Versatility</h2>
                    <p data-aos="fade-up" data-aos-offset="150" data-aos-delay="100">Produced from avocados not suited
                        for extra-virgin oil,
                        this cost-effective option retains
                        natural benefits for cosmetic and industrial uses. It’s a sustainable choice for businesses
                        seeking ethical, high-quality ingredients.</p>

                    <div class="icon-list-wrapper">
                        <ul>
                            <li data-aos="fade-up" data-aos-offset="150"><img
                                    src="./assets/images/products/check-icon.png" alt="">
                                <p>Produced using a cold-press method that retains essential nutrients.</p>
                            </li>
                            <li data-aos="fade-up" data-aos-offset="150" data-aos-delay="50"><img
                                    src="./assets/images/products/check-icon.png" alt="">
                                <p>100% chemical- and additive-free extraction process.</p>
                            </li>
                        </ul>
                    </div>
                    <h5 data-aos="fade-up" data-aos-offset="150">Packaging Options</h5>
                    <p class="bottom-para" data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">We offer
                        versatile packaging solutions
                        tailored to customer needs:</p>
                    <div class="boxes-wrapper">
                        <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150">
                            <h6>22,000 kg</h6>
                            <p>Flexitank</p>
                        </div>
                        <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">
                            <h6>IBC 1,000 kg</h6>
                            <p>Intermediate <br />
                                Bulk Containers</p>
                        </div>
                        <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="100">
                            <h6>200 kg</h6>
                            <p>Food-grade<br />
                                steel barrels</p>
                        </div>
                        <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="150">
                            <a class="knowMoreBtn" href="#staticBackdrop" data-product="Avocado Oil"
                                    data-bs-toggle="modal" data-bs-target="#staticBackdrop">
                                Get in Touch<br /> with us
                                <div class="icon-wrapper">
                                    <span class="material-symbols-outlined">
                                        east
                                    </span>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Premium Crude Avocado Oil  -->

    <!-- Stystem Commitment Section  -->
    <div class="system-commitment-section">
        <div class="container">
            <div class="system-commitment-inner">
                <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150">
                    <h2 class="section-title">Quality check
                        <span>System</span>
                    </h2>
                    <p>Greenava Foods has a rigorous quality management system that aligns with both local and
                        international food safety standards. Our commitment to excellence is ingrained in our culture
                        and drives every aspect of our operations.</p>
                </div>
                <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="100">
                    <img src="./assets/images/products/avocado.png" alt="">
                </div>
                <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="150">
                    <h2 class="section-title">Sustainability <br />
                        <span>Commitment</span>
                    </h2>
                    <p>Greenava Foods embraces a circular economy approach, ensuring that waste byproducts—such as
                        peels, stones, and exhausted pulp—are repurposed for environmental benefits or converted into
                        marketable products.</p>
                </div>
            </div>
        </div>
    </div>
    <!-- Stystem Commitment Section  -->

    <!-- Product Process  -->
    <section class="process-section-wrapper products-process-section-wrapper" data-aos="fade-up" data-aos-offset="150"
        data-aos-delay="50" style="display: none;">
        <div class="container">
            <div class="bg-wrapper" style="background-image: url(./assets/images/home/process-watch-bg.png);">
                <a href="https://www.youtube.com/watch?v=a3ICNMQW7Ok" data-fancybox="">
                    <div class="inner-wrapper">
                        <div class="left-content">
                            <h3>Production Process</h3>
                            <h2><span>Watch</span> cold-press method that<br>
                                retains essential nutrients.</h2>
                            <p>Our avocado fruits are handpicked at optimal maturity and naturally ripened. Using a
                                cold-press extraction method, we ensure that the oil retains its nutritional value. This
                                process is entirely chemical- and additive-free, guaranteeing purity and health
                                benefits.
                            </p>
                        </div>
                        <div class="right-video">
                            <p class="link-wrapper">
                                <i class="fa fa-play" aria-hidden="true"></i>
                            </p>
                        </div>
                    </div>
                </a>
            </div>
        </div>
    </section>
    <!-- Product Process  -->

    <!-- Global Industries Section  -->
    <div class="global-industries-section">
        <div class="container">
            <div class="global-industries-inner">
                <div class="top-title">
                    <h2 class="section-title" data-aos="fade-up" data-aos-offset="150">Serving Diverse<br />
                        <span>Global Industries</span>
                    </h2>
                    <p data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">Our products cater to the following
                        industries:</p>
                </div>
                <div class="global-industries-box-wrapper">
                    <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150">
                        <div class="icon-wrapper">
                            <img src="./assets/images/products/cosmetic-industry.png" alt="">
                        </div>
                        <div class="right-content">
                            <h4>Cosmetic Industry</h4>
                            <p>Natural ingredients for skincare and<br /> beauty products.</p>
                        </div>
                    </div>
                    <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="100">
                        <div class="icon-wrapper">
                            <img src="./assets/images/products/pharmaceutical-industry.png" alt="">
                        </div>
                        <div class="right-content">
                            <h4>Pharmaceutical Industry</h4>
                            <p>Nutritional and therapeutic applications.</p>
                        </div>
                    </div>
                    <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="150">
                        <div class="icon-wrapper">
                            <img src="./assets/images/products/food-industry.png" alt="">
                        </div>
                        <div class="right-content">
                            <h4>Food Industry</h4>
                            <p>Healthy cooking and gourmet products.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Global Industries Section  -->

    <!-- Market Presence Section  -->
    <div class="market-presence-section">
        <div class="container">
            <div class="market-presence-inner">
                <div class="left-section">
                    <h2 class="section-title" data-aos="fade-up" data-aos-offset="150">Market Presence <br />
                        <span>Globally</span>

                    </h2>
                    <p data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">Our products are exported to
                        <span>Europe, Asia, and the
                            Middle East,</span><br />
                        fulfilling the demands of diverse global markets.
                    </p>
                    <div class="read-more-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="150">
                        <a class="knowMoreBtn" href="#staticBackdrop" data-product="Avocado Oil" data-bs-toggle="modal"
                            data-bs-target="#staticBackdrop">Get a quick call <span class="material-symbols-outlined">
                                east
                            </span></a>
                    </div>
                </div>
                <div class="right-section">
                    <div class="image-wrapper" data-aos="zoom-in" data-aos-duration="1500">
                        <img src="./assets/images/products/market-presence.jpg" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Market Presence Section  -->

    <!-- Certification Section  -->
    <div class="certification-section">
        <div class="container">
            <div class="certification-inner">
                <div class="left-certificate-image" data-aos="zoom-in" data-aos-duration="1500">
                    <img src="./assets/images/products/certificate.png" alt="">
                </div>
                <div class="right-content">
                    <h2 class="section-title" data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">
                        Certifications</h2>
                    <p data-aos="fade-up" data-aos-offset="150" data-aos-delay="100">We maintain internal quality
                        systems benchmarked against
                        international best practices to ensure
                        the highest standards in food safety and quality. Greenava Foods EPZ Ltd—enhancing lives through
                        innovative, high-quality, and sustainable food solutions.
                    </p>
                    <!-- <div class="read-more-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="150">
                        <a href="#">Explore certificates <span class="material-symbols-outlined">
                                east
                            </span></a>
                    </div> -->
                </div>
            </div>
        </div>
    </div>
    <!-- Certification Section  -->


    <!-- Modal -->
    <div class="modal fade popupForm" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false"
        tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Enquire Now</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="" id="avocadooilForm" method="post">
                        <div class="form-group">
                            <input type="text" name="full_name" class="form-control" placeholder="Full Name">
                        </div>
                        <div class="form-group">
                            <input type="email" name="email" class="form-control" placeholder="Email ID">
                        </div>
                        <div class="form-group">
                            <input type="text" name="mobile" class="form-control" placeholder="Mobile No.">
                        </div>
                        <div class="form-group">
                            <select class="form-select" aria-label="Default select example" name="avocado_oil" id="productSelect">
                                <option value="Avocado_Oil" selected>Avocado Oil</option>
                                <option value="Sugar_Free_Dried_Mango">Sugar Free Dried Mango</option>
                                <option value="Sugar_Free_Dried_Pineapple">Sugar Free Dried Pineapple</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <textarea name="message" class="form-control" placeholder="Message"></textarea>
                        </div>
                        <div class="form-group recaptcha-wrapper">
                            <div class="g-recaptcha" data-sitekey="6Lcji3gsAAAAAP008hKQKLey3GnQhqNq7wlBbmo5"></div>
                        </div>
                        <div class="form-group">
                            <div class="submit-wrapper">
                                <button type="submit" class="submit_btn">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php include 'include/footer.php'; ?>

    <script type="text/javascript">

        $.validator.addMethod("is_valid_email", function (value, element) {
            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            return regex.test(value);
        }, "Please enter a valid email address");

        $.validator.addMethod('numericOnly', function (value) {
            return /^[0-9]+$/.test(value);
        }, 'Please enter only numeric values');

        $.validator.addMethod('noSpamEmail', function (value, element) {
            var domainJson = $.getJSON({ 'url': "assets/spam_domain.json", 'async': false });
            var bannedDomains = domainJson.responseJSON;
            var domain = value.split('@')[1];
            return bannedDomains.indexOf(domain) < 0;
        }, 'Email from this domain are not allowed');

        $.validator.addMethod("noLinks", function (value, element) {
            var linkRegex1 = /\b(?:https?|ftp):\/\/|www\.[^\s]+/i;
            var linkRegex2 = /\b(?:[a-zA-Z0-9-]+\.)+[a-zA-Z]{2,}\b/;
            return !(linkRegex1.test(value) || linkRegex2.test(value));
        }, "Links are not allowed.");

        $.validator.addMethod("noHtml", function (value, element) {
            var htmlTagRegex = /<\/?[^>]+>/gi;
            return this.optional(element) || !htmlTagRegex.test(value);
        }, "HTML tags are not allowed.");

        $.validator.addMethod("alphaOnly", function (value, element) {
            return this.optional(element) || /^[A-Za-z\s]+$/.test(value);
        }, "Only alphabetic characters are allowed.");

        $("#avocadooilForm").validate({
            ignore: [],

            rules: {
                full_name: {
                    required: true,
                    maxlength: 100,
                    noLinks: true,
                    noHtml: true,
                    alphaOnly: true
                },
                email: {
                    required: true,
                    email: true,
                    is_valid_email: true,
                    noSpamEmail: true
                },
                mobile: {
                    required: true,
                    numericOnly: true,
                    minlength: 10,
                    maxlength: 10,
                },
                avocado_oil: {
                    required: true
                },
                "g-recaptcha-response": {
                    required: true,
                },
            },
            messages: {
                full_name: {
                    required: "Enter full name.",
                    maxlength: "First name cannot exceed 50 characters.",
                    noLinks: "Links are not allowed in the first name."
                },
                email: {
                    required: "Enter email",
                    email: "Please enter a valid email address.",
                    is_valid_email: "Please enter a properly formatted email.",
                    noSpamEmail: "Disposable or spammy emails are not allowed."
                },
                mobile: {
                    required: "Enter mobile number.",
                    numericOnly: "Only numbers are allowed.",
                    minlength: "Phone number must be 10 digits.",
                    maxlength: "Phone number must be 10 digits."
                },
                avocado_oil: {
                    required: "Please select a product."
                },
                "g-recaptcha-response": {
                    required: "Please fill the captcha."
                }
            },
            errorPlacement: function (error, element) {
                if(element.attr("name") === "g-recaptcha-response") {
                    error.insertAfter(element.closest('.g-recaptcha'));
                }
                else {
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {

                $.ajax({
                    url: "include/send-avocado-oil-mail.php",
                    method: "POST",
                    data: $(form).serialize(),
                    dataType: "json",
                    beforeSend: function () {
                        $('.submit_btn').prop("disabled", true).html("<i class='fa fa-circle-o-notch fa-spin'></i> Proccesing...");
                    },
                    success: function (response) {
                        if (response.success == true) {
                            $('#avocadooilForm')[0].reset();
                            sessionStorage.setItem(
                                "thankyou_message",
                                "Thank you for contacting us; we’ll reach out to you shortly."
                            );
                            window.location.href = "thank-you.php";
                            // alert("message sent succefully");
                        } else if (response.success == false) {
                            $('#' + response.errorType).html(response.msg).show();
                        }
                        $('.submit_btn').prop("disabled", false).html("Submit");
                    },
                    error: function (error) {

                        console.error(error);
                    }
                });
                return false;
                console.log("form submited");
            }
        });
    </script>