<?php $title = 'Dried Fruits & Vegetables :: Greenava'; ?>
<?php include 'include/head.php'; ?>
<?php include 'include/header.php'; ?>

<style>
    .error {
        /* font-size: 17px !important; */
        color: red !important;
    }
</style>
    <!-- Banner Section -->
    <section class="banner-outer-section">
        <div class="banner-bg" style="background-image: url(./assets/images/dryfruits/dryfruits_hero_back.jpg);">
            <div class="container">
                <div class="banner-inner-section">
                    <div class="banner-content" data-aos="fade-up" data-aos-offset="150">
                        <h2>Dried Fruits & Vegetables</h2>
                    </div>
                    <div class="banner-image" data-aos="zoom-in" data-aos-duration="1500">
                        <img src="./assets/images/dryfruits/dry_mango_bowl.png" alt="">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Banner Section -->


    <section class="left-right-content-section dried-fruits-left-right-content-section">
        <div class="container">
            <div class="left-right-inner">
                <div class="left-content">
                    <h2 data-aos="fade-up" data-aos-offset="150">Greenava Natural<br />
                        <span>Dehydrated Fruits & Vegetables</span>
                    </h2>
                    <div class="content-para" data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">
                        <p>Dehydrated to Perfection - Naturally Preserved for Global Markets</p>
                    </div>
                </div>
                <div class="right-content">
                    <p data-aos="fade-up" data-aos-offset="150" data-aos-delay="100">Greenava Foods EPZ Ltd is an
                        EPZ-licensed agribusiness company engaged in the processing and export of premium sugar-free
                        dried mango and sugar-free dried pineapple. Based in Murang’a County, Kenya, we serve
                        international B2B markets with a strong focus on quality, traceability, sustainability, and
                        regulatory compliance.</p>
                </div>
            </div>
        </div>
    </section>


    <section class="dried-fruits-section">
        <div class="container">
            <div class="dried-fruits-inner">
                <div class="row">
                    <div class="col-md-6">
                        <div class="box-wrapper">
                            <div class="inner-wrapper">
                                <div class="products-image-slider-wrapper">
                                    <div class="inner-products-slider owl-carousel owl-theme">
                                        <div class="item">
                                            <div class="image-wrapper"><img
                                                    src="./assets/images/dryfruits/dry_mango.jpg" alt=""></div>
                                        </div>
                                        <div class="item">
                                            <div class="image-wrapper"><img
                                                    src="./assets/images/dryfruits/dry_mango-01.jpg" alt=""></div>
                                        </div>
                                        <div class="item">
                                            <div class="image-wrapper"><img
                                                    src="./assets/images/dryfruits/dry_mango-02.jpg" alt=""></div>
                                        </div>
                                        <div class="item">
                                            <div class="image-wrapper"><img
                                                    src="./assets/images/dryfruits/dry_mango-03.jpg" alt=""></div>
                                        </div>
                                        <div class="item">
                                            <div class="image-wrapper"><img
                                                    src="./assets/images/dryfruits/dry_mango-04.jpg" alt=""></div>
                                        </div>
                                        <div class="item">
                                            <div class="image-wrapper"><img
                                                    src="./assets/images/dryfruits/dry_mango-05.jpg" alt=""></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="name-wrapper">
                                    <h4>Sugar Free Dried <span>Mango</span></h4>
                                </div>
                                <div class="specifications-wrapper">
                                    <h4>Specifications</h4>
                                    <ul>
                                        <li><span>Moisture (%)</span> : 13-18%</li>
                                        <li><span>Packaging Size</span> : 25kg, 50kg</li>
                                        <li><span>Processing Form</span> : Dried</li>
                                        <li><span>Shelf Life</span> : 18-24 Months</li>
                                        <li><span>Size</span> : Fine Slicing</li>
                                        <li><span>Supply Ability</span> : 7,000-10,000 Per Kg/Week</li>
                                        <li><span>GMO Declaration</span> : Naturally Grown</li>
                                    </ul>
                                </div>
                                <div class="enquire-now-wrapper">
                                    <a class="knowMoreBtn" href="#staticBackdrop" data-product="Sugar Free Dried Mango"
                                        data-bs-toggle="modal" data-bs-target="#staticBackdrop">Enquire Now <span
                                            class="material-symbols-outlined">
                                            east
                                        </span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="box-wrapper">
                            <div class="inner-wrapper">
                                <div class="products-image-slider-wrapper">
                                    <div class="inner-products-slider owl-carousel owl-theme">
                                        <div class="item">
                                            <div class="image-wrapper"><img
                                                    src="./assets/images/dryfruits/dry_pineapple.jpg" alt=""></div>
                                        </div>
                                        <div class="item">
                                            <div class="image-wrapper"><img
                                                    src="./assets/images/dryfruits/dry_pineapple01.jpg" alt=""></div>
                                        </div>
                                        <div class="item">
                                            <div class="image-wrapper"><img
                                                    src="./assets/images/dryfruits/dry_pineapple02.jpg" alt=""></div>
                                        </div>
                                        <div class="item">
                                            <div class="image-wrapper"><img
                                                    src="./assets/images/dryfruits/dry_pineapple03.jpg" alt=""></div>
                                        </div>
                                        <div class="item">
                                            <div class="image-wrapper"><img
                                                    src="./assets/images/dryfruits/dry_pineapple04.jpg" alt=""></div>
                                        </div>
                                        <div class="item">
                                            <div class="image-wrapper"><img
                                                    src="./assets/images/dryfruits/dry_pineapple05.jpg" alt=""></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="name-wrapper">
                                    <h4>Sugar Free Dried <span>Pineapple</span></h4>
                                </div>
                                <div class="specifications-wrapper">
                                    <h4>Specifications</h4>
                                    <ul>
                                        <li><span>Moisture (%)</span> : 10-13%</li>
                                        <li><span>Packaging Size</span> : 25kg, 50kg</li>
                                        <li><span>Processing Form</span> : Dried</li>
                                        <li><span>Shelf Life</span> : 18-24 Months</li>
                                        <li><span>Size</span> : Fine Slicing</li>
                                        <li><span>Supply Ability</span> : 7,000-10,000 Per Kg/Week</li>
                                        <li><span>GMO Declaration</span> : Naturally Grown</li>
                                    </ul>
                                </div>
                                <div class="enquire-now-wrapper">
                                    <a class="knowMoreBtn" href="#staticBackdrop" data-product="Sugar Free Dried Pineapple"
                                    data-bs-toggle="modal" data-bs-target="#staticBackdrop">Enquire Now <span class="material-symbols-outlined">
                                            east
                                        </span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- Modal -->
    <div class="modal fade popupForm" id="staticBackdrop" data-bs-backdrop="static" data-bs-keyboard="false"
        tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="staticBackdropLabel">Enquire Now</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="" id="driedFruitVegetablesForm" method="post">
                        <div class="form-group">
                            <input type="text" name="full_name" class="form-control" placeholder="Full Name">
                        </div>
                        <div class="form-group">
                            <input type="email" name="email" class="form-control" placeholder="Email ID">
                        </div>
                        <div class="form-group">
                            <input type="text" name="mobile" class="form-control" placeholder="Mobile No.">
                        </div>
                        <div class="form-group">
                            <select class="form-select" aria-label="Default select example" name="vegetable_product" id="productSelect">
                                <option value="Sugar_Free_Dried_Mango">Sugar Free Dried Mango</option>
                                <option value="Sugar_Free_Dried_Pineapple">Sugar Free Dried Pineapple</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <textarea name="message" class="form-control" placeholder="Message"></textarea>
                        </div>
                        <div class="form-group recaptcha-wrapper">
                            <div class="g-recaptcha" data-sitekey="6Lcji3gsAAAAAP008hKQKLey3GnQhqNq7wlBbmo5"></div>
                        </div>
                        <div class="form-group">
                            <div class="submit-wrapper">
                                <button type="submit" class="submit_btn">Submit</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>




    <?php include('./include/footer.php'); ?>


    <script type="text/javascript">

        $.validator.addMethod("is_valid_email", function (value, element) {
            var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            return regex.test(value);
        }, "Please enter a valid email address");

        $.validator.addMethod('numericOnly', function (value) {
            return /^[0-9]+$/.test(value);
        }, 'Please enter only numeric values');

        $.validator.addMethod('noSpamEmail', function (value, element) {
            var domainJson = $.getJSON({ 'url': "assets/spam_domain.json", 'async': false });
            var bannedDomains = domainJson.responseJSON;
            var domain = value.split('@')[1];
            return bannedDomains.indexOf(domain) < 0;
        }, 'Email from this domain are not allowed');

        $.validator.addMethod("noLinks", function (value, element) {
            var linkRegex1 = /\b(?:https?|ftp):\/\/|www\.[^\s]+/i;
            var linkRegex2 = /\b(?:[a-zA-Z0-9-]+\.)+[a-zA-Z]{2,}\b/;
            return !(linkRegex1.test(value) || linkRegex2.test(value));
        }, "Links are not allowed.");

        $.validator.addMethod("noHtml", function (value, element) {
            var htmlTagRegex = /<\/?[^>]+>/gi;
            return this.optional(element) || !htmlTagRegex.test(value);
        }, "HTML tags are not allowed.");

        $.validator.addMethod("alphaOnly", function (value, element) {
            return this.optional(element) || /^[A-Za-z\s]+$/.test(value);
        }, "Only alphabetic characters are allowed.");

        $("#driedFruitVegetablesForm").validate({
            ignore: [],

            rules: {
                full_name: {
                    required: true,
                    maxlength: 100,
                    noLinks: true,
                    noHtml: true,
                    alphaOnly: true
                },
                email: {
                    required: true,
                    email: true,
                    is_valid_email: true,
                    noSpamEmail: true
                },
                mobile: {
                    required: true,
                    numericOnly: true,
                    minlength: 10,
                    maxlength: 10,
                },
                vegetable_product: {
                    required: true
                },
                "g-recaptcha-response": {
                    required: true,
                },
            },
            messages: {
                full_name: {
                    required: "Enter full name.",
                    maxlength: "First name cannot exceed 50 characters.",
                    noLinks: "Links are not allowed in the first name."
                },
                email: {
                    required: "Enter email",
                    email: "Please enter a valid email address.",
                    is_valid_email: "Please enter a properly formatted email.",
                    noSpamEmail: "Disposable or spammy emails are not allowed."
                },
                mobile: {
                    required: "Enter mobile number.",
                    numericOnly: "Only numbers are allowed.",
                    minlength: "Phone number must be 10 digits.",
                    maxlength: "Phone number must be 10 digits."
                },
                vegetable_product: {
                    required: "Please select a product."
                },
                
                "g-recaptcha-response": {
                    required: "Please fill the captcha."
                }
            },
            errorPlacement: function (error, element) {
                if(element.attr("name") === "g-recaptcha-response") {
                    error.insertAfter(element.closest('.g-recaptcha'));
                }
                else {
                    error.insertAfter(element);
                }
            },
            submitHandler: function (form) {

                $.ajax({
                    url: "include/send-dried-fruit-vegetables-mail.php",
                    method: "POST",
                    data: $(form).serialize(),
                    dataType: "json",
                    beforeSend: function () {
                        $('.submit_btn').prop("disabled", true).html("<i class='fa fa-circle-o-notch fa-spin'></i> Proccesing...");
                    },
                    success: function (response) {
                        if (response.success == true) {
                            $('#driedFruitVegetablesForm')[0].reset();
                            sessionStorage.setItem(
                                "thankyou_message",
                                "Thank you for contacting us; we’ll reach out to you shortly."
                            );
                            window.location.href = "thank-you.php";
                            // alert("message sent succefully");
                        } else if (response.success == false) {
                            $('#' + response.errorType).html(response.msg).show();
                        }
                        $('.submit_btn').prop("disabled", false).html("Submit");
                    },
                    error: function (error) {

                        console.error(error);
                    }
                });
                return false;
                console.log("form submited");
            }
        });
    </script>