

<?php $title = 'Home :: Greenava'; ?>
<?php include 'include/head.php'; ?>
<?php include 'include/header.php'; ?>

  <!-- Hero Section -->
  <section class="hero-section">
    <div class="bg-wrapper" style="background-image: url(./assets/images/home/hero-bg.jpg);">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-5 col-md-5 col-sm-12">
            <div class="hero-content">
              <h1 data-aos="fade-up" data-aos-offset="150">Sustainability, <br>Excellence &<br> Empowerment</h1>
              <p data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">We are committed to delivering
                safe,<br>premium products that
                exceed expectations.</p>
              <div data-aos="fade-up" data-aos-offset="150" data-aos-delay="150">
                <a href="./our-products.php" class="btn-explore">Explore Our Products <span
                    class="material-symbols-outlined">
                    east
                  </span></a>
              </div>
            </div>
          </div>
          <div class="col-lg-7 col-md-7 col-sm-12" data-aos="zoom-in" data-aos-duration="1500">
            <div class="owl-carousel owl-theme home-slider">
              <div class="item">
                <div class="hero-image text-center">
                  <img src="./assets/images/home/hero-right-img.png" alt="Fresh Avocado" class="img-fluid">
                </div>
              </div>
              <div class="item">
                <div class="hero-image text-center">
                  <img src="./assets/images/home/dryfruit_sliced.png" alt="Fresh Avocado" class="img-fluid">
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Squeeze Section  -->
  <section class="squeeze-section">
    <div class="container">
      <div class="squeeze-inner-wrapper">
        <div class="row">
          <div class="col-lg-7 col-md-12 col-sm-6">
            <div class="squeeze-right-image" data-aos="fade-up" data-aos-offset="150" data-aos-offset="150">
              <div class="back-image">
                <img src="./assets/images/home/squeeze-left-img.png" alt="squeeze-img">
              </div>
              <div class="farmer-image-wrapper">
                <div class="bg-image">
                  <img src="./assets/images/home/greenava_about_back.jpg" alt="">
                </div>
                <div class="farmer-img-content-wrapper">
                  <div class="image-wrapper">
                    <img src="./assets/images/home/farmer-img.png" alt="">
                  </div>
                  <div class="text-content">
                    <h3>Eco-Luxe<br />
                      Avocado Oil,<br />
                      Globally<br />
                      Inspired</h3>
                  </div>
                  <div class="link-wrapper">
                    <a href="./about-us.php"><span class="material-symbols-outlined">
                        east
                      </span></a>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-5 col-md-12 col-sm-6">
            <div class="squeeze-left-content">
              <h2 data-aos="fade-up" data-aos-offset="150">Squeeze the Day with <br />
                <span>Greenava’s Finest</span>
              </h2>
              <p data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">Greenava Foods EPZ Ltd, <b>established in 2024</b>, specializes in the extraction and marketing of <b>premium avocado oil along with the production of high-quality sugar-free dried mango and pineapple</b>. Our business is powered by advanced processing technologies, a well-trained and highly motivated team, and adherence to international quality management standards.</p>
              <p data-aos="fade-up" data-aos-offset="150" data-aos-delay="100">Our passion lies in delivering <b>healthy, natural, and eco-friendly products</b> to global markets while supporting local farmers and <b>championing environmental stewardship</b>. As a leading player in the food processing industry, we create a positive impact for all stakeholders <b>through quality, health-focused products and continuous innovation</b>.</p>
            </div>
          </div>
        </div>
        <div class="graphics-img-wrapper">
          <img src="./assets/images/home/right-graphics.png" alt="">
        </div>
      </div>
    </div>
  </section>

  <!-- Avocado oil Section  -->
  <section class="avocado-oil-section">
    <div class="container">
      <div class="avocado-oil-inner">
        <div class="avocado-img-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="100">
          <img src="./assets/images/home/abocado-1.png" alt="">
        </div>
        <div class="avocado-oil-content" data-aos="fade-up" data-aos-offset="150">
          <h4>Our Products</h4>
          <h2>Extra-Virgin and <br />Crude <b>Avocado Oil</b></h2>
          <ul>
            <li>
              <p><img src="./assets/images/home/list-icon.png" alt=""> Produced using a cold-press method<br />
                that retains essential nutrients.</p>
            </li>
            <li>
              <p><img src="./assets/images/home/list-icon.png" alt=""> 100% chemical- and additive-free<br />
                extraction process.</p>
            </li>
          </ul>
          <div class="read-more-wrapper">
            <a href="./avocado-oil.php">Read More <span class="material-symbols-outlined">
                east
              </span></a>
          </div>
        </div>
        <div class="avocado-img-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="150">
          <img src="./assets/images/home/avocado-2.png" alt="">
        </div>
      </div>
    </div>
  </section>
  <!-- Avocado oil Section  -->

  <!-- Process Section  -->
  <section class="process-section-wrapper" data-aos="fade-up" data-aos-offset="150" style="margin: 0;">
    <div class="container">
      <!-- <div class="bg-wrapper" style="background-image: url(./assets/images/home/process-watch-bg.png);"> -->
      <div class="bg-wrapper" style="padding: 0;">
        <a href="https://www.youtube.com/watch?v=a3ICNMQW7Ok" data-fancybox="" style="display: none;">
          <div class="inner-wrapper">
            <div class="left-content">
              <h3>Process</h3>
              <h2><span>Watch</span> cold-press method that<br />
                retains essential nutrients.</h2>
            </div>
            <div class="right-video">
              <p class="link-wrapper">
                <i class="fa fa-play" aria-hidden="true"></i>
              </p>
            </div>
          </div>
        </a>
        <div class="graphics-img-wrapper">
          <img src="./assets/images/home/mango_sideback.png" alt="">
        </div>
      </div>
    </div>
  </section>
  <!-- Process Section  -->

  <!-- Text bg wrapper  -->
  <div class="text-bg-wrapper" style="background-image: url(./assets/images/home/text-bg.png);">
    <section class="dehydrated-fruits-section">
      <div class="container">
        <div class="dehydrated-fruits-inner" data-aos="fade-up" data-aos-offset="150">
          <div class="left-image-section">
            <img src="./assets/images/home/dehydrated-fruits.jpg" alt="">
            <!-- <div class="top-image">
              <img src="./assets/images/home/dehydrated-avocado-top.jpg" alt="">
            </div> -->
          </div>
          <div class="right-content-section">
            <!-- <h3>Future Products</h3> -->
            <h2>Dehydrated <span>Fruits </span><br />
              & <span>Vegetables</span></h2>
            <div class="para-content">
              <p>We currently produce premium sugar-free dried mango and dried pineapple, carefully processed to preserve natural flavor, color, and nutrients using advanced, chemical-free dehydration techniques.</p>
              <p>As part of our expansion, we are developing a wider range of dehydrated fruits and vegetables including avocado, banana, passion fruit, chili, and green beans.</p>
            </div>
            <div class="read-more-wrapper">
              <a href="./dried-fruits-and-vegetables.php">Know More <span class="material-symbols-outlined">
                  east
                </span></a>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="purpose-vision-mission-wrapper">
      <div class="container">
        <div class="purpose-vision-mission-inner">
          <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150">
            <div class="inner-wrapper">
              <div class="inner-top-wrapper">
                <div class="top-text-icon-wrapper">
                  <h3>Our<br /> <span>Purpose</span></h3>
                  <div class="icon-wrapper">
                    <img src="./assets/images/home/our-purpose-icon.png" alt="">
                  </div>
                </div>
                <div class="para-content">
                  <p>To nurture a healthier world
                    by producing sustainable,
                    high-quality food products that empower communities, respect
                    the environment, and inspire innovation.</p>
                </div>
              </div>
              <div class="link-wrapper">
                <a href="./about-us.php"><span class="material-symbols-outlined">
                    call_made
                  </span></a>
              </div>
            </div>
          </div>
          <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="100">
            <div class="inner-wrapper">
              <div class="inner-top-wrapper">
                <div class="top-text-icon-wrapper">
                  <h3>Our<br /> <span>Mission</span></h3>
                  <div class="icon-wrapper">
                    <img src="./assets/images/home/our-mission-icon.png" alt="">
                  </div>
                </div>
                <div class="para-content">
                  <p>To create value for customers, farmers, and all stakeholders
                    by engaging in socially, environmentally, and
                    economically responsible practices.</p>
                </div>
              </div>
              <div class="link-wrapper">
                <a href="./about-us.php"><span class="material-symbols-outlined">
                    call_made
                  </span></a>
              </div>
            </div>
          </div>
          <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="150">
            <div class="inner-wrapper">
              <div class="inner-top-wrapper">
                <div class="top-text-icon-wrapper">
                  <h3>Our<br /> <span>Vision</span></h3>
                  <div class="icon-wrapper">
                    <img src="./assets/images/home/our-vision-icon.png" alt="">
                  </div>
                </div>
                <div class="para-content">
                  <p>To be a leading global producer of safe, high-quality products that are synonymous with innovation
                    and sustainability.</p>
                </div>
              </div>
              <div class="link-wrapper">
                <a href="./about-us.php"><span class="material-symbols-outlined">
                    call_made
                  </span></a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>
  <!-- Text bg wrapper  -->

  <!-- Nutring Frams Section  -->
  <div class="nutring-frams-section">
    <div class="custom-container">
      <div class="inner-wrapper">
        <div class="nutring-frams-inner">
          <div class="left-section">
            <h2 data-aos="fade-up" data-aos-offset="150">Nurturing Farms,<br />
              Reducing Waste,<br />
              Building Tomorrow</h2>
            <p data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">Greenava Foods embraces a circular economy
              approach, ensuring that
              waste byproducts—such as peels,
              stones,
              and exhausted pulp - are repurposed for environmental benefits or converted into marketable products.</p>
            <p class="mb-0" data-aos="fade-up" data-aos-offset="150" data-aos-delay="100">
              We partner with local avocado farmers practicing sustainable agriculture, fostering economic growth and
              environmental care.
            </p>
            <div class="mobile-graphics-img-wrapper">
              <img src="./assets/images/home/leaf-graphics.png" alt="">
            </div>
          </div>
          <div class="right-image" data-aos="fade-zoom-in" data-aos-delay="150">
            <img src="./assets/images/home/nutring-frams.png" alt="">
          </div>
        </div>
        <div class="graphics-img-wrapper">
          <img src="./assets/images/home/leaf-graphics.png" alt="">
        </div>
      </div>
    </div>
  </div>
  <!-- Nutring Frams Section  -->

  <?php include './include/footer.php'; ?>