AOS.init({
	once: true,
	duration: 1000,
});

$('.custom1').owlCarousel({
	loop: true,
	animateOut: 'fadeOut',
	animateIn: 'slideInRight',
	items: 1,
	margin: 30,
	nav: false,
	dots: false,
	smartSpeed: 450,
	autoplay: true,
	autoplayTimeout: 8000,
});


document.addEventListener('DOMContentLoaded', function () {
	var splide = new Splide('#featured-slider', {
		autoScroll: {
			speed: 2,
		},
		type: 'loop',
		arrows: boolean = false,
		pagination: boolean = false,
		gap: '20px',
		perPage: 6,
		autoStart: boolean = true,
		pauseOnHover: boolean = true,
		focus: 'center',
		breakpoints: {
			480: {
				perPage: 2,
				gap: '10px',
			},
			768: {
				perPage: 3.5
			},
			1400: {
				perPage: 5.5,
			},
		}

	});
	splide.mount(window.splide.Extensions);
});


$('.home-services-slider').owlCarousel({
	loop: true,
	margin: 20,
	autoplay: false,
	autoplaySpeed: 1000,
	nav: false,
	center: false,
	dots: false,
	responsive: {
		0: {
			items: 1
		},
		260: {
			items: 2,

		},
		380: {
			items: 3,

		},
		768: {
			items: 3,

		},
		992: {
			items: 3,

		},
		1300: {
			items: 4,

		}
	}
});
$('.home-slider').owlCarousel({
	loop: true,
	animateOut: 'fadeOut',
	animateIn: 'fadeIn',
	margin: 0,
	autoplay: true,
	// autoplaySpeed: 1000,
	nav: false,
	center: false,
	items: 1,
	dots: false,
	// responsive: {
	// 	0: {
	// 		items: 1
	// 	},
	// 	260: {
	// 		items: 2,

	// 	},
	// 	380: {
	// 		items: 3,

	// 	},
	// 	768: {
	// 		items: 3,

	// 	},
	// 	992: {
	// 		items: 3,

	// 	},
	// 	1300: {
	// 		items: 4,

	// 	}
	// }
});
$('.inner-products-slider').owlCarousel({
	loop: true,
	animateOut: 'fadeOut',
	animateIn: 'fadeIn',
	margin: 0,
	autoplay: true,
	autoplaySpeed: 1000,
	nav: false,
	center: false,
	items: 1,
	dots: false,
	// responsive: {
	// 	0: {
	// 		items: 1
	// 	},
	// 	260: {
	// 		items: 2,

	// 	},
	// 	380: {
	// 		items: 3,

	// 	},
	// 	768: {
	// 		items: 3,

	// 	},
	// 	992: {
	// 		items: 3,

	// 	},
	// 	1300: {
	// 		items: 4,

	// 	}
	// }
});


$(document).ready(function () {

	$('.celebrity-slider').owlCarousel({
		loop: true,
		rewind: true,
		margin: 0,
		autoplay: true,
		stagePadding: 250,
		autoplaySpeed: 1000,
		nav: false,
		center: true,
		dots: false,
		responsive: {
			0: {
				items: 1
			},
			260: {
				items: 1,
				stagePadding: 12,

			},
			380: {
				items: 1,
				stagePadding: 20,

			},
			768: {
				items: 1,

			},
			992: {
				items: 2,

			},
			1300: {
				items: 3,

			},
			1400: {
				items: 3,

			}
		}
	});

	$('.celebrity-facial-slider').owlCarousel({
		loop: true,
		rewind: true,
		margin: 0,
		autoplay: true,
		stagePadding: 150,
		autoplaySpeed: 1000,
		nav: false,
		center: true,
		dots: true,
		responsive: {
			0: {
				items: 1
			},
			260: {
				items: 1,
				stagePadding: 12,

			},
			380: {
				items: 1,
				stagePadding: 20,

			},
			768: {
				items: 1,

			},
			992: {
				items: 2,

			},
			1300: {
				items: 3,

			},
			1400: {
				items: 3,

			}
		}
	});

	$('.clinic-gallery-slider').owlCarousel({
		loop: true,
		// stagePadding: 100,
		margin: 20,
		autoplay: true,
		autoplaySpeed: 1000,
		nav: false,
		dots: false,
		responsive: {
			0: {
				items: 1
			},
			260: {
				items: 1,

			},
			380: {
				items: 1,
				// stagePadding: 30,

			},
			768: {
				items: 1,

			},
			992: {
				items: 1,

			},
			1300: {
				items: 1,

			},
			1400: {
				items: 1,

			}
		}
	});

});



$(document).ready(function () {

	$(window).scroll(function () {
		var scroll = $(window).scrollTop();
		if (scroll >= 150) {
			$("header").addClass("sticky");
		} else {
			$("header").removeClass("sticky");
		}
	});
	// slowScroll();

});




var didScroll, lastScrollTop = 0;

var navbar = {
	duration: 300, // (ms) add css transition for 300 sec (css transition is 200)
	delta: 1, // (px) buffer (user has to scroll x to toggle navbar)
	transitioning: false, // changing state
	minimize: function () {
		if (this.el.hasClass('is-maximized')) {
			this.transition();
		}
		// Hide top menu
		this.el.removeClass('is-maximized').addClass('is-minimized');
	},
	maximize: function () {
		if (this.el.hasClass('is-minimized')) {
			this.transition();
		}
		this.el.removeClass('is-minimized').addClass('is-maximized');
	},
	transition: function () {
		var _this = this;

		// could have transition in css and toggle class is-transitioning here
		// but we're using duration for the setTimeout so easier to have everything together in js


		// top menu visible
		_this.el.find('.top-section').css('visibility', 'visible');

		// add css transition
		_this.transitioning = true;
		_this.el.css({
			'-webkit-transform': 'transform ' + _this.duration + 'ms',
			'-moz-transform': 'transform ' + _this.duration + 'ms',
			'-ms-transform': 'transform ' + _this.duration + 'ms',
			'-o-transform': 'transform ' + _this.duration + 'ms',
			'transition': 'transform ' + _this.duration + 'ms'
		});

		// remove css transform when transition is done
		setTimeout(function () {
			_this.el.css('transition', 'none');
			_this.transitioning = false;
			// top menu hidden
			if (_this.el.hasClass('is-minimized')) {
				_this.el.find('.top-section').css('visibility', 'hidden');
			}
		}, _this.duration)

	},
	handleScroll: function () {
		//var st = $(this).scrollTop();
		var st = $(window).scrollTop();
		var navbar_height = this.el.outerHeight();

		// Make sure they scroll more than delta and navbar is not transitioning
		if (Math.abs(lastScrollTop - st) <= this.delta || this.transitioning)
			return;

		// If they scrolled down and are past the navbar, add class .is-minimized.
		// This is necessary so you never see what is "behind" the navbar.
		// Scroll Down: minimize (hide top menu)
		if (st > lastScrollTop && st > navbar_height) {
			this.minimize();
		}
		// Scroll Up: maximize (show top menu)
		else if (st + $(window).height() < $(document).height()) {
			this.maximize();
		}

		lastScrollTop = st;
	},
	handleLogoClick: function (e) {
		e.preventDefault();
		this.maximize();
	},
	init: function (id) {

		var _this = this;
		_this.el = $(id);

		// === SCROLL
		$(window).scroll(function (event) {
			didScroll = true;
		});

		setInterval(function () {
			if (didScroll) {
				_this.handleScroll();
				didScroll = false;
			}
		}, 50);

		// === CLICK ON LOGO 
		var logo = _this.el.find('.bottom-section .navbar-logo');
		logo.on('click', function (e) {
			_this.handleLogoClick(e);
		});
	}
};

navbar.init('#navbar');



// $(document).on("click", ".knowMoreBtn", function () {
// 	let selectedProduct = $(this).data("product");
// 	$("#productSelect").val(selectedProduct);
// });