<?php $title = 'Our Process :: Greenava'; ?>
<?php include 'include/head.php'; ?>
<?php include 'include/header.php'; ?>

    <!-- Banner Section -->
    <section class="banner-outer-section process-banner-outer-section">
        <div class="banner-bg process-banner-bg"
            style="background-image: url(./assets/images/process/our_process_hero_back.jpg);">
            <div class="container">
                <div class="banner-inner-section">
                    <div class="banner-content" data-aos="fade-up" data-aos-offset="150">
                        <h2>Our Process</h2>
                    </div>
                    <div class="banner-image" data-aos="zoom-in" data-aos-duration="1500">
                        <img src="./assets/images/process/avocado_dehdrated_fruits_process.png" alt="">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Banner Section -->

    <!-- Tabs  -->
    <div class="tabs-section">
        <div class="container">
            <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill"
                        data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home"
                        aria-selected="true">Avocado Oil Extraction
                        Process</button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill"
                        data-bs-target="#pills-profile" type="button" role="tab" aria-controls="pills-profile"
                        aria-selected="false">Dried Fruits
                        Vegetables</button>
                </li>
            </ul>
        </div>
        <div class="tab-content" id="pills-tabContent">
            <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab"
                tabindex="0">
                <!-- Tab Content  -->
                <div class="content-wrapper">
                    <div class="container">
                        <section class="left-right-content-section products-left-right-content-section">
                            <h2 class="section-title" data-aos="fade-up" data-aos-offset="150">Avocado Oil
                                <span>Extraction
                                    Process</span>
                            </h2>
                            <div class="left-right-inner">
                                <div class="left-content">
                                    <!-- <h2>Purely Natural,<br />
                        <span>Passionately Greenava</span>
                    </h2> -->
                                    <div class="content-para" data-aos="fade-up" data-aos-offset="150"
                                        data-aos-delay="50">
                                        <p>Premium Avocado Oil <br />for Health and Versatility</p>
                                    </div>
                                </div>
                                <div class="right-content" data-aos="fade-up" data-aos-offset="150"
                                    data-aos-delay="100">
                                    <p>The extraction of high-quality avocado oil in a large-scale factory involves
                                        a<br />
                                        meticulous,
                                        multi-step process designed to maximize yield while preserving the<br /> oil’s
                                        nutritional value
                                        and
                                        flavor.<br />
                                        Below is an overview of the key stages:</p>
                                </div>
                            </div>
                        </section>
                        <section class="three-column-section">
                            <div class="three-column-inner">
                                <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150">
                                    <h3>Fruit Selection and Sorting</h3>
                                    <p>Mature Avocados on a tree mature at different times. Only fruits that have
                                        reached
                                        the right
                                        maturity are hand-picked. Once delivered to the factory, they are naturally
                                        ripened
                                        under
                                        controlled conditions before processing
                                    </p>
                                </div>
                                <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">
                                    <h3>Washing and Cleaning</h3>
                                    <p>Avocados are thoroughly washed to remove dirtand other contaminants. This step is
                                        critical to
                                        meet food safety standards for edible oil production.</p>
                                </div>
                                <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="100">
                                    <h3>Peeling and Destoning</h3>
                                    <p>The avocados are peeled and pitted, leaving only the nutrient-rich pulp.
                                        Specialized
                                        de-stoning
                                        and peeling units ensure minimal waste and high efficiency.</p>
                                </div>
                                <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="150">
                                    <h3>Pulp Preparation (Mashing)</h3>
                                    <p>The pulp is ground into a smooth paste, using industrial malaxers. Controlled
                                        temperatures
                                        prevent degradation of bioactive compounds like chlorophylls and carotenoids.
                                    </p>
                                </div>
                                <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150">
                                    <h3>Oil Extraction (Cold Mechanical Extraction)</h3>
                                    <p>Using Alfa Laval’s X-Series decanter enables high extraction efficiency under
                                        controlled
                                        low-temperature conditions, preserving key quality parameters such as natural
                                        antioxidants,
                                        fatty acid integrity, and sensory characteristics.</p>
                                </div>
                                <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">
                                    <h3>Clarification and Purification</h3>
                                    <p>Residual water and solids are removed using vertical separators to produce clear,
                                        high-quality
                                        oil. This step enhances shelf life and ensures the oil meets export standards.
                                    </p>
                                </div>
                                <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="100">
                                    <h3>Storage and Packaging</h3>
                                    <p>The extracted oil is stored in stainless steel tanks with conical bottoms. This
                                        design allows
                                        natural settling of the oil so that any residual water or particles collect at
                                        the
                                        base of the
                                        tank and can be removed easily. Once clarified, the settled oil is packaged
                                        under
                                        hygienic
                                        conditions and prepared for dispatch.</p>
                                </div>
                                <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="150">
                                    <a href="./contact-us.php">Get in Touch With Us
                                        <div class="icon-wrapper">
                                            <span class="material-symbols-outlined">
                                                call_made
                                            </span>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </section>
                        <div class="checkpoints-bg-wrapper" style="display: none;">
                            <!-- Process Section  -->
                            <section class="process-section-wrapper"
                                style="background-image: url(./assets/images/process/greenava-process-text-bg.png);"
                                data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">
                                <div class="bg-wrapper"
                                    style="background-image: url(./assets/images/home/process-watch-bg.png);">
                                    <a href="https://www.youtube.com/watch?v=a3ICNMQW7Ok" data-fancybox="">
                                        <div class="inner-wrapper">
                                            <div class="left-content">
                                                <h3>Process</h3>
                                                <h2><span>Watch</span> cold-press method that<br />
                                                    retains essential nutrients.</h2>
                                            </div>
                                            <div class="right-video">
                                                <p class="link-wrapper">
                                                    <i class="fa fa-play" aria-hidden="true"></i>
                                                </p>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </section>
                            <!-- Process Section  -->

                            <!-- Checkpoints Section  -->
                            <div class="checkpoints-section">
                                <div class="checkpoints-inner">
                                    <div class="top-section">
                                        <h2 class="section-title" data-aos="fade-up" data-aos-offset="150">Quality
                                            Control
                                            <span>Checkpoints</span>
                                        </h2>
                                        <p data-aos="fade-up" data-aos-offset="150" data-aos-delay="50">To ensure the
                                            avocado oil meets
                                            stringent export
                                            standards, multiple quality<br /> control
                                            (QC)
                                            checkpoints are integrated throughout the production process.</p>
                                    </div>
                                    <div class="two-cloumn-section">
                                        <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150">
                                            <div class="icon-wrapper">
                                                <img src="./assets/images/process/quality_inspection.png" alt="">
                                            </div>
                                            <div class="right-content">
                                                <h3>Fruit Quality Inspection</h3>
                                                <p>All incoming avocados are checked using a standardized intake
                                                    checklist
                                                    for maturity,
                                                    physical condition, and infection. Only fruits with optimal
                                                    ripeness,
                                                    minimal
                                                    damage,
                                                    and no deep infections are accepted, ensuring production of
                                                    high-quality
                                                    oil.</p>
                                            </div>
                                        </div>
                                        <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150"
                                            data-aos-delay="50">
                                            <div class="icon-wrapper">
                                                <img src="./assets/images/process/temperature.png" alt="">
                                            </div>
                                            <div class="right-content">
                                                <h3>Paste Temperature Monitoring</h3>
                                                <p>During processing, paste temperature is closely monitored to maintain
                                                    optimal levels
                                                    for
                                                    maximum oil extraction while preventing oil degradation from
                                                    excessive
                                                    heat.</p>
                                            </div>
                                        </div>
                                        <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150"
                                            data-aos-delay="100">
                                            <div class="icon-wrapper">
                                                <img src="./assets/images/process/quality_testing.png" alt="">
                                            </div>
                                            <div class="right-content">
                                                <h3>Quality Testing</h3>
                                                <p>Each batch of oil is tested in our in-house laboratory to monitor
                                                    Free
                                                    Fatty Acid
                                                    (FFA)
                                                    levels and ensure that the production consistently meets customer
                                                    specifications.
                                                </p>
                                            </div>
                                        </div>
                                        <div class="box-wrapper" data-aos="fade-up" data-aos-offset="150"
                                            data-aos-delay="150">
                                            <div class="icon-wrapper">
                                                <img src="./assets/images/process/tank_storage.png" alt="">
                                            </div>
                                            <div class="right-content">
                                                <h3>Stainless Steel Tanks for Storage</h3>
                                                <p>Food-grade stainless steel tanks are used for bulk storage. These
                                                    tanks
                                                    are equipped
                                                    with
                                                    inert gas systems (e.g., nitrogen blanketing) to prevent oxidation.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- Checkpoints Section  -->

                        </div>
                    </div>
                    <!-- Certification Section  -->
                    <div class="certification-section">
                        <div class="container">
                            <div class="certification-inner">
                                <div class="left-certificate-image" data-aos="zoom-in" data-aos-duration="1500">
                                    <img src="./assets/images/products/certificate.png" alt="">
                                </div>
                                <div class="right-content">
                                    <h2 class="section-title" data-aos="fade-up" data-aos-offset="150"
                                        data-aos-delay="50">
                                        Certifications</h2>
                                    <p data-aos="fade-up" data-aos-offset="150" data-aos-delay="100">We maintain
                                        internal
                                        quality
                                        systems benchmarked against
                                        international best practices to ensure
                                        the highest standards in food safety and quality. Greenava Foods EPZ
                                        Ltd—enhancing
                                        lives through
                                        innovative, high-quality, and sustainable food solutions.
                                    </p>
                                    <!-- <div class="read-more-wrapper" data-aos="fade-up" data-aos-offset="150" data-aos-delay="150">
                        <a href="#">Explore certificates <span class="material-symbols-outlined">
                                east
                            </span></a>
                    </div> -->
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Certification Section  -->
                </div>
                <!-- Tab Content  -->
            </div>
            <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab"
                tabindex="0">
                <!-- Tab Content  -->
                <div class="content-wrapper">
                    <h2 class="coming-soon-text">Coming Soon...</h2>
                </div>
                <!-- Tab Content  -->
            </div>
        </div>
    </div>

    <!-- Tabs  -->



    <?php include 'include/footer.php'; ?>